//====================================================
// Terrain with Detail mapping
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;    
   matrix ViewInv:ViewInverse; 

//--------------
// tweaks
//--------------
   float4 TerrainVec={0,0,12800,12800};
   float2 Terrain1UV={16,16};
   float3 LightColor={1.0f,0.75f,0.75f};
   float3 Lightdir={-0.384,-0.573,-0.723};
   float3 Ambient={0.2f,0.2f,0.2f};
   float4 FogColor={0.5f,0.5f,0.6f,1.0f};
   float FogRange=20000.0f;

//--------------
// Textures
//--------------
   texture NormalsTX <string Name = "";>;	
   sampler Normals=sampler_state 
      {
 	Texture=<NormalsTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };
   texture ShadowTX <string Name = "";>;	
   sampler Shadow=sampler_state 
      {
 	Texture=<ShadowTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };
   texture BaseTX <string Name = "";>;	
   sampler Base=sampler_state 
      {
 	Texture=<BaseTX>;
      };
   texture DetailTX <string Name = "";>;	
   sampler Detail=sampler_state 
      {
 	Texture=<DetailTX>;
      };

//--------------
// structs 
//--------------
   struct In_Diffuse
     {
 	float4 Pos:POSITION; 
 	float2 UV:TEXCOORD0;  
     };
   struct Out_Diffuse
     {
	float4 OPos:POSITION; 
 	float2 Tex1:TEXCOORD0;
 	float2 Tex2:TEXCOORD1;
	float Fog:FOG;
     };

//--------------
// vertex shader
//--------------
   Out_Diffuse VS(In_Diffuse IN) 
     {
 	Out_Diffuse OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
 	float3 WPos=mul(IN.Pos,World);
 	float2 UV=(WPos.xz-TerrainVec.xy)/TerrainVec.zw; 
	OUT.Tex1=UV;
 	OUT.Tex2=-UV*Terrain1UV;
	float3 ViewPos=ViewInv[3].xyz-WPos;
	OUT.Fog=1-saturate(dot(ViewPos/FogRange,ViewPos/FogRange));
	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(Out_Diffuse IN) : COLOR
     { 
	float4 ColMap=tex2D(Base,IN.Tex1);
	float3 DetailMap=1-tex2D(Detail,IN.Tex2);
	float3 Normal=tex2D(Normals,IN.Tex1)*2-1;
	return float4(((ColMap+DetailMap)-0.5f)*(saturate(dot(-Lightdir,Normal)*tex2D(Shadow,IN.Tex1)*LightColor)+Ambient),1);
     }

//--------------
// techniques   
//--------------
   technique TerrainDetailmap
      {
 	pass p1
      {		
 	vertexShader = compile vs_1_1 VS(); 
 	pixelShader  = compile ps_1_4 PS();
	FOGCOLOR=(FogColor); 
	FOGENABLE=TRUE;	
      }
      }

//====================================================
// Velocity + Depth (Add Tis To All Surface Shaders)
//====================================================

//tweaks
   matrix PreviousVP;
   float NearFocus=50.0f;
   float FarFocus=2500.0f;

//structs 
   struct IN_Velocity
       {
        float4 Pos:POSITION;
       };
   struct OUT_Velocity
       {
 	float4 OPos:POSITION; 
    	float4 CurrentPos:TEXCOORD0; 
    	float4 PreviousPos:TEXCOORD1; 
     	float Depth:TEXCOORD2;
       };
   struct input_Black
       {
 	float4 Pos:POSITION;
       };
   struct output_Black
       {
 	float4 OPos:POSITION; 
       };

//vertex shader
   OUT_Velocity VS_Velocity(IN_Velocity IN) 
    {
 	OUT_Velocity OUT;
	OUT.OPos=mul(IN.Pos,WorldVP);
 	OUT.CurrentPos=mul(IN.Pos,WorldVP);
	OUT.PreviousPos=mul(mul(IN.Pos,World),PreviousVP);
        OUT.Depth=OUT.OPos.z; 
	return OUT;
    }
   output_Black VS_Black(input_Black IN) 
     {
 	output_Black OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
	return OUT;
     }

//pixel shader
    float4 PS_Velocity(OUT_Velocity IN)  : COLOR
     {		
   	float2 velocity=((IN.CurrentPos/IN.CurrentPos.w)-(IN.PreviousPos/IN.PreviousPos.w));
        float CloseDepth=saturate(1-(IN.Depth/NearFocus));	
        float FarDepth=CloseDepth+saturate((-NearFocus+IN.Depth)/FarFocus);	
	return float4(velocity,FarDepth,1);
     }
    float4 PS_Black(output_Black IN)  : COLOR
     {		
	return float4(0,0,0,1);
     }

// techniques   
    technique VelocityDOF
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS_Velocity(); 
 	pixelShader  = compile ps_2_0 PS_Velocity();	
      }
      }
  technique Black
      {
 	pass p1
      {		
 	vertexShader = compile vs_1_1 VS_Black(); 
 	pixelShader  = compile ps_1_1 PS_Black();
      }
      }
